

export class SalesPlanMonthWidget {
	
	
	tpl = `
	<div class="spm">
		
		<div class="yearno">
			<div class="article-name-placeholder"></div>
			<div class="current-year">
				{{year}}
			</div>
		</div>
		<div class="monthno-list">
			<div class="article-name-placeholder"></div>
			<div class="monthno-list-items" ez-for="monthList" ez-item="m">
				<div class="monthno {{m.monthno == currentMonth && year == currentYear ? 'current-monthno' : '' }}" [month]="m" [onclick]="widget.weekClick">{{m.monthno}}</div>
			</div>
		</div>
		
		
		<div ez-if="articles.length == 0" class="no-results">
			Geen resultaten gevonden
		</div>
		<div ez-for="articles" ez-item="art">
			<div class="article">
				<div class="article-name" [article]="art" [onclick]="widget.articleClick">
					{{art.shortDescription}}
				</div>
				<div class="monthno-month-items" ez-for="monthList" ez-item="m">
					<div class="month-item">..</div>
				</div>
			</div>
		</div>

	</div>
	
	
	`;
	
	container = null;
	
	ezTpl = null;
	
	monthList = [];
	articles = [];
	year = null;
	
	
	callback_monthSelect = null;
	callback_daySelect = null;
	
	
	constructor() {
		
	}
	
	
	init(c) {
		this.container = c;
	}
	
	
	setYear(no) { this.year = parseInt(no); }
	setArticles(arts) { this.articles = arts; }
	
	setCallbackMonthSelect(callback) {
		this.callback_monthSelect = callback;
	}
	
	setCallbackDaySelect(callback) {
		this.callback_daySelect = callback;
	}
	
	
	buildMonths() {
		
		this.monthList = [];
		for( let mno = 1; mno <= 12; mno++ ) {
			
			this.monthList.push({
				year: this.year,
				monthno: mno
			});
		}
	}
	
	
	render() {
		this.buildMonths();
		
		let d = new Date();
		
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('monthList', this.monthList);
		this.ezTpl.setVar('year', this.year);
		this.ezTpl.setVar('articles', this.articles);
		
		this.ezTpl.setVar('currentYear', d.getFullYear());
		this.ezTpl.setVar('currentMonth', d.getMonth()+1);
		
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		
		this.ezTpl.render();
		
	}
	
	weekClick(evt) {
		let o = evt.target;
		let m = o.month;
		
		
		console.log('weekClick', m);
		if (this.callback_monthSelect != null) {
			let strMonth = ''+m.monthno;
			if (strMonth.length == 1)
				strMonth = '0' + strMonth;
			
			let d = str2date( ym.year + '-' + strMonth + '-01' );
			
			this.callback_monthSelect( d );
		}
	}
	
	
	articleClick( evt ) {
		let o = evt.target;
		let art = o.article;
		
		// jump to day view
		if (art.pricingMethod == '' || art.pricingMethod == 'slotplan') {
			if (this.callback_daySelect)
				this.callback_daySelect( new Date() );
		}
		// jump to week view
		else if (art.pricingMethod == 'week') {
			if (this.callback_monthSelect)
				this.callback_monthSelect( new Date() );
		}
		else {
			showToastMessage( 'Verhuur per maand' );
		}
		
		console.log( art );
	}
	
	
	
}

